/**
 * \file: perm.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: Secure Data Container
 * \brief : functions to map sdc permissions to imx6 permissions
 *
 * <b>SDC private header</b>
 *
 * \author: Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef __SDC_LIB_CAAM_PERM_H_
#define __SDC_LIB_CAAM_PERM_H_

#include <unistd.h>
#include <sys/types.h>
#include <sdc.h>
#include <sdc_perm.h>
#include <private/sdc_arch.h>
#include <private/sdc_intern.h>
#include <linux/caam_km.h>

struct sdc_perm_to_caam_perm_map {
    sdc_perm_bmsk_t sdc_perm_bit;
    uint32_t caam_perm_bit;
};

SDC_ARCH_EXTERN_API sdc_error_t caam_key_perms_to_sdc_permissions(const struct caam_key_perms *caam_perm,
                                                                  sdc_permissions_t *sdc_perm);

SDC_ARCH_EXTERN_API sdc_error_t sdc_permissions_to_caam_key_perms(const sdc_permissions_t *sdc_perm,
                                                                  struct caam_key_perms *caam_perm);

SDC_ARCH_EXTERN_API uint32_t sdc_uid_to_caam_uid(uid_t uid);
SDC_ARCH_EXTERN_API uint32_t sdc_gid_to_caam_gid(gid_t gid);
SDC_ARCH_EXTERN_API uid_t caam_uid_to_sdc_uid(uint32_t uid);
SDC_ARCH_EXTERN_API gid_t caam_gid_to_sdc_gid(uint32_t gid);


#endif
